/* COPYRIGHT 2000 by 3rd-evolution
 * Author: Thomas Krammer (tkrammer@3rd-evolution.de)
 */

#ifndef DIALOG_BASE_H
#define DIALOG_BASE_H

#include "FlickerFreeButton.h"

const int32 MSG_OK							= 'mOK ';
const int32 MSG_CANCEL						= 'mCAN';

class CDialogBase : public BView
{
	public:
	CDialogBase(BRect frame, const char *name, 
		uint32 resizingMode=B_FOLLOW_ALL, 
		uint32 flags=B_FRAME_EVENTS,
		const char *okButtonLabel=NULL,
		const char *cancelButtonLabel=NULL);
	
	virtual ~CDialogBase();
	
	virtual BRect ClientRect();
	
	virtual void AttachedToWindow();
	virtual void MessageReceived(BMessage *message);
	virtual void KeyDown(const char *bytes, int32 numBytes);
	virtual void GetPreferredSize(float *width, float *height);
	virtual void FrameResized(float width, float height);

	protected:
	// called if the user presses the OK button or enters return
	virtual bool Ok() { return true; }
	// called if the user presses the CANCEL button or presses ESC
	virtual void Cancel() {}
	
	void SetOkButtonLabel(const char *label)		{ okButton->SetLabel(label); }
	void SetCancelButtonLabel(const char *label)	{ cancelButton->SetLabel(label); }
	
	virtual void EnableOkButton(bool enable=true)	{ okButton->SetEnabled(enable); }
	
	static const float dist;
	
	BButton *okButton, *cancelButton;
};

class CHelpButton : public CFlickerFreeButton
{
	public:
	CHelpButton(BRect frame, const char *name, BMessage *message,
		uint32 resizingMode=B_FOLLOW_LEFT|B_FOLLOW_TOP,
		uint32 flags=B_WILL_DRAW | B_NAVIGABLE);
	
	virtual void GetPreferredSize(float *width, float *height);
	
	// Returns true if the button is pressed (highlighted)
	bool IsHighlighted() { return Value() == B_CONTROL_ON; }

	virtual void Draw(BRect updateRect);
	
	void SetDrawFont();
};

class CEscapeMessageFilter : public BMessageFilter
{
	public:
	CEscapeMessageFilter(BHandler *_escTarget);

	virtual filter_result Filter(BMessage *message, BHandler **target);
	
	protected:
	BHandler *escTarget;
};

#endif // DIALOG_BASE_H