/* COPYRIGHT 2000 by 3rd-evolution
 * Author: Thomas Krammer (tkrammer@3rd-evolution.de)
 */

#ifndef LCD_SPECTRUM_PLUGIN_H
#define LCD_SPECTRUM_PLUGIN_H

#include "VisualizationPlugin.h"
#include "FrontEnd.h"

extern "C" _EXPORT VisualizationPlugin* NewPlugin(int *Version);

class CLCDSpectrum_Plugin : public VisualizationPlugin
{
	public:
	CLCDSpectrum_Plugin();
	virtual ~CLCDSpectrum_Plugin();
	
	virtual bool Init();
	virtual void Cleanup();
	virtual bool About(bool Question);
	virtual bool Prefs(bool Question);
	virtual unsigned long GetFlags();

	// SongInfo() is not yet implemented by current version of CL-Amp
	virtual void SongInfo(struct SongInfoStruct *info) {}
	// Render() is called everytime CL-Amp is adding data to the audio stream (if Init() returns VISPLUG_NEED_AUDIO_DATA)
	virtual bool Render(const struct VisAudioInfoStruct *info);
	
	void Lock()		{ lock.Lock(); }
	void Unlock()	{ lock.Unlock(); }

	void SetSerialDevice(const char *device);
	void SetDisplayWidth(int8 width);
	void SetDisplayHeight(int8 height)		{ displayHeight	= height; }
	void SetDisplaySongInfo(bool display)	{ displaySongInfo = display; }
	
	const char *SerialDevice()	{ return serialDevice.String(); }
	int8 DisplayWidth()			{ return displayWidth; }
	int8 DisplayHeight()		{ return displayHeight; }
	bool DisplaysSongInfo()		{ return displaySongInfo; }
	
	static int32 ThreadStartFunc(void *data);
	void AsyncRender();
	
	protected:
	void ReadSettings();
	void WriteSettings();
	
	BLocker lock;
	
	BString serialDevice;
	
	thread_id renderThread;	// does the output
	bool exitThread;		// tells the renderThread to exit
	
	// ---- access this data only, if the plugin is locked!
	ISerialDisplay *serialDisplay;
	CLAmp_FrontEnd *frontEnd;
	
	bool displaySongInfo;
	bigtime_t scrollDelay;
	
	int8 displayWidth;		// columns
	int8 displayHeight;		// rows
	uint8 *spectrumData;	// data for each column (0-255)
};

class CPluginPrefView : public CDialogBase
{
	public:
	CPluginPrefView(BRect frame, CLCDSpectrum_Plugin *_plugin, uint32 resizingMode=B_FOLLOW_ALL, 
		uint32 flags=B_FRAME_EVENTS);
	virtual ~CPluginPrefView();
	
	virtual void AttachedToWindow();
	virtual void GetPreferredSize(float *width, float *height);
	virtual void MessageReceived(BMessage *message);
	
	virtual bool Ok();
	
	protected:
	BMenuField	*serialSel;
	BMenuField	*sizeSel;
	BCheckBox   *displayInfoSel;
	
	static const float dist;
	
	CLCDSpectrum_Plugin *plugin;
	
	int8 selWidth, selHeight;
	BString selSerDevice;
	bool selDisplayInfo;
};

const int32 MSG_SIZE_SELECTED		= 'mSSE';
const int32 MSG_SER_DEVICE_SELECTED	= 'mSDS';

#endif LCD_SPECTRUM_PLUGIN_H